IF NOT EXISTS
(
    SELECT *
    FROM   SYS.TABLES
    WHERE  NAME = 'ADM_ERRO_EST_NF_INTEGRACOES'
)
	BEGIN

		/****** Object:  Table [dbo].[ADM_ERRO_EST_NF_INTEGRACOES]    Script Date: 13/01/2017 09:49:36 ******/
		SET ANSI_NULLS ON

		SET QUOTED_IDENTIFIER ON

		CREATE TABLE [dbo].[ADM_ERRO_EST_NF_INTEGRACOES](
			[CD_CONTROLE] [int] IDENTITY(1,1) NOT NULL,
			[NR_NF] [int] NOT NULL,
			[DT_EMI_NF] [datetime] NOT NULL,
			[CD_FORN] [int] NOT NULL,
			[SERIE_NF] [varchar](10) NOT NULL,
			[TP_TRANSA] [int] NOT NULL,
			[CNPJ_FORN] [varchar](50) NOT NULL,
			[NR_AUTORIZADOR] [varchar](150) NOT NULL,
			[JSON_ENVIADO] [varchar](max) NOT NULL,
			[STS_ERRO] [int] NOT NULL,
			[CD_USU_CORRECAO] [int] NULL,
			[DT_CORRECAO] [datetime] NULL,
			[LAUDO] [varchar](500) NULL,
			[DT_CAD] [datetime] NULL,
			[CODIGO] [int] NULL,
		CONSTRAINT [PK_ADM_ERRO_EST_NF_INTEGRACOES_1] PRIMARY KEY CLUSTERED 
		(
		[CD_CONTROLE] ASC
		)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
		) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]


		ALTER TABLE [dbo].[ADM_ERRO_EST_NF_INTEGRACOES] ADD  CONSTRAINT [DF_ADM_ERRO_EST_NF_INTEGRACOES_NR_NF]  DEFAULT ((0)) FOR [NR_NF]

		ALTER TABLE [dbo].[ADM_ERRO_EST_NF_INTEGRACOES] ADD  CONSTRAINT [DF_ADM_ERRO_EST_NF_INTEGRACOES_CD_FORN]  DEFAULT ((0)) FOR [CD_FORN]

		ALTER TABLE [dbo].[ADM_ERRO_EST_NF_INTEGRACOES] ADD  CONSTRAINT [DF_ADM_ERRO_EST_NF_INTEGRACOES_SERIE_NF]  DEFAULT ('') FOR [SERIE_NF]

		ALTER TABLE [dbo].[ADM_ERRO_EST_NF_INTEGRACOES] ADD  CONSTRAINT [DF_ADM_ERRO_EST_NF_INTEGRACOES_TP_TRANSA]  DEFAULT ((0)) FOR [TP_TRANSA]

		ALTER TABLE [dbo].[ADM_ERRO_EST_NF_INTEGRACOES] ADD  CONSTRAINT [DF_ADM_ERRO_EST_NF_INTEGRACOES_CNPJ_FORN]  DEFAULT ('') FOR [CNPJ_FORN]

		ALTER TABLE [dbo].[ADM_ERRO_EST_NF_INTEGRACOES] ADD  CONSTRAINT [DF_ADM_ERRO_EST_NF_INTEGRACOES_CHAVE_NFE]  DEFAULT ('') FOR [NR_AUTORIZADOR]

		ALTER TABLE [dbo].[ADM_ERRO_EST_NF_INTEGRACOES] ADD  CONSTRAINT [DF_ADM_ERRO_EST_NF_INTEGRACOES_STS_ERRO]  DEFAULT ((0)) FOR [STS_ERRO]

		ALTER TABLE [dbo].[ADM_ERRO_EST_NF_INTEGRACOES] ADD  CONSTRAINT [DF_ADM_ERRO_EST_NF_INTEGRACOES_CD_USU_CORRECAO]  DEFAULT ((0)) FOR [CD_USU_CORRECAO]

		ALTER TABLE [dbo].[ADM_ERRO_EST_NF_INTEGRACOES] ADD  CONSTRAINT [DF_ADM_ERRO_EST_NF_INTEGRACOES_CODIGO]  DEFAULT ((0)) FOR [CODIGO]

		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0 - entrada, 1 - saida' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ADM_ERRO_EST_NF_INTEGRACOES', @level2type=N'COLUMN',@level2name=N'TP_TRANSA'

		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0 - pendente - 1 - Importado - 2 - Erro - 3 - Reprocessado - 4 - Ignorado - 5 - Importado Anteriormente' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ADM_ERRO_EST_NF_INTEGRACOES', @level2type=N'COLUMN',@level2name=N'STS_ERRO'

		EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ADM_ERRO_EST_NF_INTEGRACOES', @level2type=N'COLUMN',@level2name=N'STS_ERRO'

		EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ADM_ERRO_EST_NF_INTEGRACOES', @level2type=N'COLUMN',@level2name=N'TP_TRANSA'

		CREATE NONCLUSTERED INDEX [IX_ADM_ERRO_EST_NF_INTEGRACOES_NR_NF_DT_EMI_NF_CD_FORN_SERIE_NF_TP_TRANSA] ON [dbo].[ADM_ERRO_PDV_VD_INTEGRACOES]
			(
				[NR_NF] ASC,
				[DT_EMI_NF] ASC,
				[CD_FORN] ASC,
				[SERIE_NF] ASC,
				[TP_TRANSA] ASC
			)
			WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

	END